/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.MultipleNodePOAnalysis;
import ibm.nways.analysis.dpCommon.PollingObjectAnalysis;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.ThresholdAnalyzer;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnList;

public class MultipleNodeAnalysisPanel
extends Panel {
    private static final char DELIM = '|';
    private MultipleNodePOAnalysis mnpoa;
    private JCMultiColumnList overallTable;
    private JCMultiColumnList weekdayTable;
    private Label weekdayLabel;
    private ThresholdAnalyzer threshAnalyzer;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AnalysisPanelResources");
    private String[] headings = new String[9];
    private int numOfRows;

    public MultipleNodeAnalysisPanel(ThresholdAnalyzer thresholdAnalyzer, String string) {
        this.numOfRows = 10;
        this.threshAnalyzer = thresholdAnalyzer;
        this.initialize(string);
    }

    public MultipleNodeAnalysisPanel(ThresholdAnalyzer thresholdAnalyzer, String string, MultipleNodePOAnalysis multipleNodePOAnalysis) {
        this.numOfRows = multipleNodePOAnalysis.objects.length;
        this.threshAnalyzer = thresholdAnalyzer;
        this.initialize(string);
        this.setData(multipleNodePOAnalysis);
    }

    public void setData(MultipleNodePOAnalysis multipleNodePOAnalysis) {
        PollingObjectAnalysis pollingObjectAnalysis;
        StringBuffer stringBuffer;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(4);
        NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
        numberFormat2.setMaximumFractionDigits(1);
        FieldPosition fieldPosition = new FieldPosition(1);
        int n = 0;
        while (n < multipleNodePOAnalysis.objects.length) {
            stringBuffer = new StringBuffer(250);
            pollingObjectAnalysis = multipleNodePOAnalysis.objects[n];
            if (pollingObjectAnalysis != null) {
                stringBuffer.append(multipleNodePOAnalysis.nodeNames[n]);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.instanceId != null) {
                    stringBuffer.append(pollingObjectAnalysis.instanceId);
                }
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallMean, stringBuffer, fieldPosition);
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallSd, stringBuffer, fieldPosition);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.thresholdOperator != null) {
                    stringBuffer.append(pollingObjectAnalysis.thresholdOperator);
                    stringBuffer.append(" ");
                }
                numberFormat.format(pollingObjectAnalysis.thresholdValue, stringBuffer, fieldPosition);
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallHighWaterMark, stringBuffer, fieldPosition);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.overallHighWaterTime != -1L) {
                    dateFormat.format(new Date(pollingObjectAnalysis.overallHighWaterTime), stringBuffer, fieldPosition);
                }
                stringBuffer.append('|');
                numberFormat.format(pollingObjectAnalysis.overallLowWaterMark, stringBuffer, fieldPosition);
                stringBuffer.append('|');
                if (pollingObjectAnalysis.overallLowWaterTime != -1L) {
                    dateFormat.format(new Date(pollingObjectAnalysis.overallLowWaterTime), stringBuffer, fieldPosition);
                }
                this.overallTable.addItem(stringBuffer.toString(), '|');
            }
            ++n;
        }
        if (multipleNodePOAnalysis.objects.length > 0 && multipleNodePOAnalysis.objects[0].weekdayN > 0) {
            n = 0;
            while (n < multipleNodePOAnalysis.objects.length) {
                stringBuffer = new StringBuffer(250);
                pollingObjectAnalysis = multipleNodePOAnalysis.objects[n];
                if (pollingObjectAnalysis != null) {
                    stringBuffer.append(multipleNodePOAnalysis.nodeNames[n]);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.instanceId != null) {
                        stringBuffer.append(pollingObjectAnalysis.instanceId);
                    }
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdayMean, stringBuffer, fieldPosition);
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdaySd, stringBuffer, fieldPosition);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.thresholdOperator != null) {
                        stringBuffer.append(pollingObjectAnalysis.thresholdOperator);
                        stringBuffer.append(" ");
                    }
                    numberFormat.format(pollingObjectAnalysis.thresholdValue, stringBuffer, fieldPosition);
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdayHighWaterMark, stringBuffer, fieldPosition);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.weekdayHighWaterTime != -1L) {
                        dateFormat.format(new Date(pollingObjectAnalysis.weekdayHighWaterTime), stringBuffer, fieldPosition);
                    }
                    stringBuffer.append('|');
                    numberFormat.format(pollingObjectAnalysis.weekdayLowWaterMark, stringBuffer, fieldPosition);
                    stringBuffer.append('|');
                    if (pollingObjectAnalysis.weekdayLowWaterTime != -1L) {
                        dateFormat.format(new Date(pollingObjectAnalysis.weekdayLowWaterTime), stringBuffer, fieldPosition);
                    }
                    this.weekdayTable.addItem(stringBuffer.toString(), '|');
                }
                ++n;
            }
            return;
        }
        this.weekdayTable.setVisible(false);
        this.weekdayLabel.setVisible(false);
    }

    protected void initialize(String string) {
        this.headings[0] = this.res.getString("s_Name");
        this.headings[1] = this.res.getString("s_Inst");
        this.headings[2] = this.res.getString("s_Mean");
        this.headings[3] = this.res.getString("s_Sd");
        this.headings[4] = this.res.getString("s_Thresh");
        this.headings[5] = this.res.getString("s_hw");
        this.headings[6] = this.res.getString("s_hwt");
        this.headings[7] = this.res.getString("s_lw");
        this.headings[8] = this.res.getString("s_lwt");
        this.setLayout(new ColumnLayout(10));
        JCLabel jCLabel = new JCLabel(string);
        jCLabel.setFont(new Font("Helvetica", 1, 14));
        Panel panel = new Panel();
        panel.add(jCLabel);
        this.add(panel);
        this.overallTable = new JCMultiColumnList(this.numOfRows, false);
        this.overallTable.setColumnButtons(this.headings);
        this.add(new Label(String.valueOf(this.res.getString("s_24")) + "  " + this.threshAnalyzer.getTimeRangeString()));
        this.add(this.overallTable);
        this.weekdayTable = new JCMultiColumnList(this.numOfRows, false);
        this.weekdayTable.setColumnButtons(this.headings);
        this.weekdayLabel = new Label(this.res.getString("s_Weekday"));
        this.add(this.weekdayLabel);
        this.add(this.weekdayTable);
    }
}

